# user.pl - Perl library file containing user and password functions
# for MVD


sub AddUser{
  local (*Form) = @_;

  if (&CheckUser($Form{'uname'},$Form{'pword'},1)){
    if(($Form{'opword'} eq "") || ($Form{'ouname'} eq "")){
      &Success("You need to supply both a username and password for the new member.<p>Use your browser's 'Back' button to go back and retry.",1);       
    }

  #if (&CheckUser($Form{'ouname'},$Form{'opword'})){
   # &Success("$Form{'ouname'} < $Form{'opword'} > is already a member of MVD.",1);    
  #}

   $new_username = crypt($Form{'ouname'}, substr($Form{'ouname'}, 0, 2));

   open(FILE,$passwd_file) || &Success("AddUser could not open the pw file for reading.<p>Please report this to the site administrator: <a href=mailto:shambhala\@telusplanet.net\?subject=MVD_error_report> Mariposa </a>",1);
   @lines = <FILE>;
   close(FILE);  
     foreach $line (@lines){
        if ($line =~ /\b$new_username:/) { 
          &Success("There is already a member by the name of $Form{'ouname'}. Please use your browser's 'Back' button and try again.",1); 
        }
     }
   
      open(PASSWD,">>$passwd_file") || &Success("AddUser could not open the pw file for appending.<p>Please report this to the site administrator: <a href=mailto:shambhala\@telusplanet.net\?subject=MVD_error_report> Mariposa </a>",1);
      $new_password = crypt($Form{'opword'}, substr($Form{'opword'}, 0, 2));
      #$new_username = crypt($Form{'ouname'}, substr($Form{'ouname'}, 0, 2));
      print PASSWD "$new_username:$new_password\n";
      close(PASSWD);
      $message = "New member - $Form{'ouname'} added to MVD by $Form{'uname'}.";
      
      &mailForm($owner, $owner, "MVD user added", "$message\n");
      &Success("$message");
  }
  &BadCombo("member with level 1 clearance");  
  exit;
}

sub DeleteUser{
  local (*Form) = @_;

  if (&CheckUser($Form{'uname'},$Form{'pword'},1)){
    if(($Form{'opword'} eq "") || ($Form{'ouname'} eq "")){
      &Success("You need to supply both a username and password for the member you wish to delete.<p>Use your browser's 'Back' button to go back and retry.",1); 
    }
      
    if (!&CheckUser($Form{'ouname'},$Form{'opword'},0)){
      &Success("Can't find the member you wish to delete: $Form{'ouname'} < $Form{'opword'} ><p>Use your browser's 'Back' button to go back and retry.",1);      
    }

    $del_passwd = crypt($Form{'opword'}, substr($Form{'opword'}, 0, 2));
    $del_username = crypt($Form{'ouname'}, substr($Form{'ouname'}, 0, 2));
      
    open(PASSWD, $passwd_file) || &Success("DeleteUser could not open the pw file for reading.<p>Please report this to the site administrator: <a href=mailto:shambhala\@telusplanet.net\?subject=MVD_error_report> Mariposa </a>",1);
    @lines = <PASSWD>;
    close(PASSWD);  
    foreach $line (@lines){
      $line =~ s/$del_username:$del_passwd\n//;
    }
     
    open(PASSWD,">$passwd_file") || &Success("DeleteUser could not open the pw file for writing.<p>Please report this to the site administrator: <a href=mailto:shambhala\@telusplanet.net\?subject=MVD_error_report> Mariposa </a>",1);
    print PASSWD @lines;
    close(PASSWD);
      $message = "Member - $Form{'ouname'} deleted from MVD by $Form{'uname'}.";      
      &mailForm($owner, $owner, "MVD user deleted", "$message\n");
      &Success("$message<p>");
  }
  &BadCombo("member with level 1 clearance");  
  exit;
}

sub ChangeUser {
  local (*Form) = @_;

  if (&CheckUser($Form{'uname'},$Form{'pword'},0)){
    $test_user = crypt($Form{'uname'}, substr($Form{'uname'}, 0, 2));
    $test_passwd = crypt($Form{'pword'}, substr($Form{'pword'}, 0, 2));
    
    if ($Form{'ouname'}){
      $userfile = $Form{'uname'} . ".dat";
      $newuserfile = $Form{'ouname'} . ".dat";

      $new_username = crypt($Form{'ouname'}, substr($Form{'ouname'}, 0, 2));

      open(FILE,$passwd_file);
      @lines = <FILE>;
      close(FILE);  
      foreach $line (@lines){
         if ($line =~ /\b$new_username\:/) { 
           &Success("There is already a member by the name of $Form{'ouname'}. Please use your browser's 'Back' button and try again.",1);           
         }
      }

      if(-e $userfile){ rename $userfile,$newuserfile;}

      $message1 = "Current username - $Form{'uname'} successfully changed to $Form{'ouname'}.<p> "; 
    }
    else {
      $new_username = $test_user;
    }
  
    if ($Form{'opword'}){
      $new_password = crypt($Form{'opword'}, substr($Form{'opword'}, 0, 2));
      $message2 = "Current password - $Form{'pword'} successfully changed to $Form{'opword'}.<p> "; 
    }
    else {
      $new_password = $test_passwd;
    }
      
      open(PASSWD, $passwd_file) || &Success("ChangeUser could not open the pw file for reading.<p>Please report this to the site administrator: <a href=mailto:shambhala\@telusplanet.net\?subject=MVD_error_report> Mariposa </a>",1);
      @lines = <PASSWD>;
      close(PASSWD);
      foreach $line (@lines){
      $line =~ s/$test_user:$test_passwd/$new_username:$new_password/;
      }
      open(PASSWD,">$passwd_file") || &Success("ChangeUser could not open the pw file for writing.<p>Please report this to the site administrator: <a href=mailto:shambhala\@telusplanet.net\?subject=MVD_error_report> Mariposa </a>",1);
      print PASSWD @lines;
      close(PASSWD);
    
    &mailForm($owner, $owner, "MVD user changed", "$message1\n$message2");
    &Success("$message1$message2<p>Make sure you record this change so you won't forget it.");    
  }  
  &BadCombo("MVD member"); # invalid username and password combination 
  exit;
}

sub CheckUser {
  local ($uname,$pword,$checklevel1) = @_;

  if(($uname eq "") || ($pword eq "")){
    &Success("You need to supply both your username and password.<p>Use your browser's 'Back' button to go back and retry.",1);     
  }
      
   open(PASSWD, $passwd_file) || &Success("CheckUser could not open the pw file for reading.<p>Please report this to the site administrator: <a href=mailto:shambhala\@telusplanet.net\?subject=MVD_error_report> Mariposa </a>",1);
   
   if($checklevel1){
     $passwd_line = <PASSWD>;
     close(PASSWD);
     chop($passwd_line) if $passwd_line =~ /\n$/;

     ($username,$passwd) = split(/:/,$passwd_line);
     $test_passwd = crypt($pword, substr($passwd, 0, 2));
     $test_user = crypt($uname, substr($username, 0, 2));
     #chop($passwd);
     if ($test_user eq $username && $test_passwd eq $passwd  && $username ne "" && $passwd ne ""){
       return 1;
     }
     else {
       return 0;
     }
   }

   @passwd_lines = <PASSWD>;
   close(PASSWD);
   foreach $passwd_line (@passwd_lines){
   chop($passwd_line) if $passwd_line =~ /\n$/;

   ($username,$passwd) = split(/:/,$passwd_line);
   $test_passwd = crypt($pword, substr($passwd, 0, 2));
   $test_user = crypt($uname, substr($username, 0, 2));
   #chop($passwd);
     if ($test_user eq $username && $test_passwd eq $passwd && $username ne "" && $passwd ne ""){
       return 1;
     }
   }
   return 0;  
}

sub BadCombo {
local ($message) = @_;
  print <<EOF;
Content-type: text/html

<HTML>
<HEAD><TITLE> MVD Warning </TITLE></HEAD>
<BODY BGCOLOR="#99CCCC"><CENTER>
<p><hr size=2><p>
<H2>Only a $message can perform this function</h2>
<table width=550 border=0><td><h3>
Your request has been rejected due to an invalid username and password combination.
If you think you mis-typed you can use your browser's back button to try again.
If you are a $message and still keep getting rejected send some email to the librarian:<center>
<a href=mailto:shambhala\@telusplanet.net\?subject=MVD_help_request> Mariposa </a></center>
</td></table><p><hr size=2><a href="$homelink" target=_top> [ Global Dialog Home ] </a><a href="$mvdhomelink"> [ MVD Home ] </a><a href="$listlink"> [ List ] </a><hr>
</CENTER></BODY></HTML>
EOF
}

1; # Library files must end with the satement "1;" 
   # to satisfy the require operator.